<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MainAccount extends Model
{
    use HasFactory;

    protected $table = 'general_ledger_accounts';
    protected $primaryKey = 'account_id';

    protected $fillable = [
        'code',
        'name',
        'account_type_id',
        'financial_category',
        'department_code',
        'has_subaccounts',
        'parent_id',
    ];

    public function accountType()
    {
        return $this->belongsTo(AccountType::class, 'account_type_id');
    }

    public function parent()
    {
        return $this->belongsTo(MainAccount::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(MainAccount::class, 'parent_id');
    }
}
