<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Rate extends Model
{
    protected $table = 'currency_rates';
    protected $primaryKey = 'rate_id';
    protected $fillable = ['base_currency_id', 'target_currency_id', 'rate_date', 'exchange_rate', 'source'];

    public function baseCurrency()
    {
        return $this->belongsTo(Currency::class, 'base_currency_id', 'currency_id');
    }

    public function targetCurrency()
    {
        return $this->belongsTo(Currency::class, 'target_currency_id', 'currency_id');
    }
}
