<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Role extends Model
{
    use HasFactory;

    protected $table = 'roles';
    protected $primaryKey = 'id';

    protected $fillable = [
        'name',
        'description',
    ];

    public function setNameAttribute($value)
    {
        $this->attributes['role_name'] = $value;
    }

    public function setDescriptionAttribute($value)
    {
        $this->attributes['role_description'] = $value;
    }

    public function getNameAttribute()
    {
        return $this->attributes['role_name'];
    }

    public function getDescriptionAttribute()
    {
        return $this->attributes['role_description'];
    }

    public function users()
    {
        return $this->hasMany(User::class, 'role_id');
    }

    public function userRoles()
    {
        return $this->hasMany(UserRole::class, 'role_id');
    }
}
