<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SubAccount extends Model
{
    use HasFactory;

    protected $table = 'subaccounts';
    protected $primaryKey = 'subaccount_id';

    protected $fillable = [
        'main_account_code',
        'main_account_name',
        'sub_account_code',
        'sub_account_name',
        'company_code',
    ];

    public function mainAccount()
    {
        return $this->belongsTo(MainAccount::class, 'main_account_code', 'code');
    }
}
