<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Supplier extends Model
{
    use HasFactory;

    protected $table = 'suppliers';
    protected $primaryKey = 'supplier_id';

    protected $fillable = [
        'supplier_code',
        'supplier_name',
        'full_name',
        'contact_person',
        'contact_1',
        'contact_2',
        'email',
        'address',
        'category_id',
        'age_analysis_id',
        'area_id',
    ];

    public function category()
    {
        return $this->belongsTo(SupplierCategory::class, 'category_id');
    }

    public function ageAnalysis()
    {
        return $this->belongsTo(AgeingAnalysis::class, 'age_analysis_id');
    }

    public function area()
    {
        return $this->belongsTo(SupplierArea::class, 'area_id');
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class);
    }

    public function subAccount()
    {
        return $this->belongsTo(SubAccount::class, 'supplier_code', 'sub_account_code');
    }
}
