<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SupplierInvoice extends Model
{
    protected $table = 'supplier_invoices';

    protected $fillable = [
        'supplier_id',
        'invoice_number',
        'invoice_date',
        'due_date',
        'amount',
        'description',
        'status',
        'account',
        'narration',
        'reference',
        'gl_account',
        'tax_id',
        'discount',
        'price',
        'quantity',
        'currency_id',
        'operation_cost',
        'tax_amount',
        'total'
    ];

    protected $casts = [
        'invoice_date' => 'date',
        'due_date' => 'date',
        'amount' => 'decimal:2',
        'price' => 'decimal:2',
        'quantity' => 'decimal:2',
        'discount' => 'decimal:2',
        'tax_amount' => 'decimal:2',
        'total' => 'decimal:2',
        'operation_cost' => 'decimal:2',
    ];

    public function supplier()
    {
        return $this->belongsTo(Supplier::class, 'supplier_id');
    }

    public function tax()
    {
        return $this->belongsTo(Tax::class, 'tax_id');
    }

    public function currency()
    {
        return $this->belongsTo(Currency::class, 'currency_id');
    }

    public function lines()
    {
        return $this->hasMany(SupplierInvoiceLine::class, 'invoice_id');
    }

    public function getDocumentDateAttribute()
    {
        return $this->invoice_date;
    }

    public function getDocumentNumberAttribute()
    {
        return $this->invoice_number;
    }
}
