<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SystemSettings extends Model
{
    protected $fillable = [
        'default_currency_id',
        'default_language',
        'timezone',
        'date_format',
        'number_format',
        'email_notifications',
        'auto_backup_frequency',
        'case_number_prefix',
        'invoice_number_prefix',
        'quotation_number_prefix',
        'receipt_number_prefix',
        'default_case_status',
        'default_payment_terms',
        'tax_calculation_method',
        'file_upload_size_limit',
        'session_timeout',
        'maintenance_mode',
    ];

    protected $casts = [
        'email_notifications' => 'boolean',
        'maintenance_mode' => 'boolean',
        'default_payment_terms' => 'integer',
        'file_upload_size_limit' => 'integer',
        'session_timeout' => 'integer',
        'smtp_port' => 'integer',
    ];

    public function defaultCurrency(): BelongsTo
    {
        return $this->belongsTo(Currency::class, 'default_currency_id');
    }
}
