<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Tariff extends Model
{
    use HasFactory;

    protected $table = 'tariffs';
    protected $primaryKey = 'tariff_id';

    protected $fillable = [
        'lawyer_id',
        'lawyer_tier_id',
        'lawyer_group_id',
        'lawyer_type_id',
        'lawyer_tier',
        'service_name',
        'billing_method',
        'rate_type',
        'rate_amount',
        'currency',
        'effective_from',
        'minimum_fee',
        'maximum_fee',
        'billing_increment',
        'retainer_required',
        'retainer_amount',
        'court_level',
        'complexity_level',
        'tax_inclusive',
        'vat_rate',
        'effective_to',
        'description',
    ];
}
