<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserPhone extends Model
{
    use HasFactory;

    protected $table = 'user_phones';

    protected $primaryKey = 'phone_id';

    public $incrementing = false;

    protected $fillable = [
        'user_id',
        'phone_number',
        'phone_type',
        'is_verified',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
