<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserTier extends Model
{
    use HasFactory;

    protected $table = 'user_tiers';
    protected $primaryKey = 'tier_id';

    protected $fillable = [
        'tier_name',
        'description',
    ];

    public function users()
    {
        return $this->hasMany(User::class, 'tier_id');
    }
}
