<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('assignments', function (Blueprint $table) {
            $table->bigIncrements('assignment_id');
            $table->string('assignment_title', 191);
            $table->string('lawyer_id', 20)->index('lawyer_id');
            $table->enum('task_type', ['document_review', 'client_meeting', 'court_appearance', 'research', 'filing', 'correspondence', 'administrative']);
            $table->enum('priority', ['low', 'medium', 'high']);
            $table->unsignedBigInteger('client_id')->nullable()->index('client_id');
            $table->unsignedBigInteger('case_id')->nullable()->index('case_id');
            $table->string('case_type_id', 50)->nullable();
            $table->string('case_category_id', 20)->nullable();
            $table->date('due_date');
            $table->time('due_time')->nullable();
            $table->decimal('estimated_hours', 5)->nullable();
            $table->enum('status', ['pending', 'in_progress', 'completed', 'cancelled'])->nullable()->default('pending');
            $table->text('description');
            $table->text('instructions')->nullable();
            $table->text('documents_required')->nullable();
            $table->date('court_date')->nullable();
            $table->time('court_time')->nullable();
            $table->string('court_location', 191)->nullable();
            $table->string('opposing_counsel', 191)->nullable();
            $table->unsignedBigInteger('judge_id')->nullable()->index('judge_id');
            $table->text('client_contact_info')->nullable();
            $table->text('billing_notes')->nullable();
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('assignments');
    }
};
