<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cache_store', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('cache_key', 191)->unique('cache_key');
            $table->text('cache_value')->nullable();
            $table->timestamp('expires_at')->nullable()->index('idx_cache_expires');
            $table->boolean('is_locked')->nullable()->default(false)->index('idx_cache_locked');
            $table->string('locked_by', 100)->nullable();
            $table->timestamp('lock_expires_at')->nullable();
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cache_store');
    }
};
