<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('case_lawyers', function (Blueprint $table) {
            $table->bigIncrements('case_lawyer_id');
            $table->unsignedBigInteger('case_id');
            $table->string('lawyer_id', 20)->index('lawyer_id');
            $table->unsignedInteger('lawyer_role_id')->index('fk_case_lawyer_role');
            $table->unsignedBigInteger('tier_id')->nullable()->index('tier_id');
            $table->unsignedBigInteger('tariff_id')->nullable()->index('tariff_id');
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->boolean('is_active')->nullable()->default(true);
            $table->text('notes')->nullable();
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();

            $table->unique(['case_id', 'lawyer_id'], 'unique_case_lawyer');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('case_lawyers');
    }
};
