<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('case_parties', function (Blueprint $table) {
            $table->bigIncrements('case_party_id');
            $table->unsignedBigInteger('case_id')->index('fk_case_parties_case');
            $table->unsignedBigInteger('client_id')->index('fk_case_parties_client');
            $table->string('party_name');
            $table->unsignedBigInteger('role_in_case')->index('fk_case_parties_role');
            $table->text('notes')->nullable();
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('case_parties');
    }
};
