<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('case_reasons', function (Blueprint $table) {
            $table->bigInteger('id', true);
            $table->string('reason_code', 50);
            $table->string('reason_name');
            $table->text('reason_description')->nullable();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent();
            $table->bigInteger('created_by')->index('fk_case_reasons_created_by');
            $table->bigInteger('updated_by')->index('fk_case_reasons_updated_by');
            $table->boolean('status')->default(true);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('case_reasons');
    }
};
