<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cases', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('case_id', 50)->unique('case_id');
            $table->string('case_name');
            $table->string('category_code', 50)->index('fk_cases_category');
            $table->unsignedBigInteger('type_id')->index('fk_cases_type');
            $table->string('status_code', 50)->index('fk_cases_status');
            $table->string('reason_code', 50)->nullable()->index('fk_cases_reason');
            $table->unsignedBigInteger('outcome_code')->nullable()->index('fk_cases_outcome');
            $table->unsignedBigInteger('priority_id')->index('fk_cases_priority');
            $table->unsignedBigInteger('role_id')->index('fk_cases_role');
            $table->unsignedBigInteger('client_id')->index('fk_cases_client');
            $table->text('notes')->nullable();
            $table->unsignedBigInteger('created_by')->index('fk_cases_created_by');
            $table->unsignedBigInteger('updated_by')->nullable()->index('fk_cases_updated_by');
            $table->date('date_of_incident')->nullable();
            $table->date('court_appearance_date')->nullable();
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cases');
    }
};
