<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cashbook_entries', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('cashbook_id')->index('idx_cashbook_entries_cashbook_id');
            $table->date('entry_date')->index('idx_cashbook_entries_entry_date');
            $table->enum('module', ['AR', 'AP', 'GL', 'CB'])->index('idx_cashbook_entries_module');
            $table->unsignedBigInteger('account_id')->index('idx_cashbook_entries_account_id');
            $table->string('reference_det')->nullable();
            $table->text('description');
            $table->enum('tr_code', ['DR', 'CR'])->index('idx_cashbook_entries_tr_code');
            $table->unsignedBigInteger('currency_id');
            $table->decimal('amount', 15);
            $table->timestamp('created_at')->nullable()->useCurrent()->index('idx_cashbook_entries_created_at');
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cashbook_entries');
    }
};
