<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cashbooks', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('code', 50)->unique('code');
            $table->string('name');
            $table->enum('cashbook_type', ['CASH', 'BANK'])->index('idx_cashbooks_type');
            $table->boolean('is_trust')->default(false)->index('idx_cashbooks_trust');
            $table->unsignedBigInteger('currency_id')->index('idx_cashbooks_currency');
            $table->decimal('opening_balance', 18)->default(0);
            $table->date('opening_balance_date')->nullable();
            $table->string('bank_name')->nullable();
            $table->string('branch_name')->nullable();
            $table->string('account_number', 100)->nullable();
            $table->string('swift_code', 50)->nullable();
            $table->boolean('is_reconcilable')->default(true);
            $table->boolean('is_active')->default(true);
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cashbooks');
    }
};
