<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('chat_messages', function (Blueprint $table) {
            $table->bigIncrements('message_id');
            $table->unsignedBigInteger('chat_id')->index('chat_id');
            $table->unsignedBigInteger('sender_id')->index('sender_id');
            $table->enum('message_type', ['text', 'file', 'audio', 'video', 'call', 'notification'])->nullable()->default('text');
            $table->text('message')->nullable();
            $table->unsignedBigInteger('file_id')->nullable()->index('file_id');
            $table->enum('call_type', ['audio', 'video'])->nullable();
            $table->enum('call_status', ['missed', 'answered', 'declined'])->nullable();
            $table->boolean('is_read')->nullable()->default(false);
            $table->boolean('is_deleted')->nullable()->default(false);
            $table->timestamp('sent_at')->nullable()->useCurrent();
            $table->timestamp('read_at')->nullable();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('chat_messages');
    }
};
