<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('chat_participants', function (Blueprint $table) {
            $table->bigIncrements('participant_id');
            $table->unsignedBigInteger('chat_id')->index('chat_id');
            $table->unsignedBigInteger('user_id')->index('user_id');
            $table->enum('role', ['member', 'admin', 'owner'])->nullable()->default('member');
            $table->timestamp('joined_at')->nullable()->useCurrent();
            $table->timestamp('last_seen')->nullable();
            $table->boolean('is_muted')->nullable()->default(false);
            $table->boolean('is_blocked')->nullable()->default(false);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('chat_participants');
    }
};
