<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('chat_rooms', function (Blueprint $table) {
            $table->bigIncrements('chat_id');
            $table->enum('chat_type', ['private', 'group'])->nullable()->default('private');
            $table->string('group_name', 191)->nullable();
            $table->text('group_description')->nullable();
            $table->string('group_avatar_url', 191)->nullable();
            $table->unsignedBigInteger('created_by')->index('created_by');
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
            $table->unsignedBigInteger('last_message_id')->nullable()->index('last_message_id');
            $table->boolean('is_active')->nullable()->default(true);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('chat_rooms');
    }
};
