<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('client_invoices', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('client_id');
            $table->string('invoice_number', 200)->unique('invoice_number');
            $table->date('invoice_date')->index('idx_invoice_date');
            $table->string('case_reference', 200);
            $table->text('description');
            $table->string('responsible_lawyer', 200);
            $table->text('narration');
            $table->string('gl_account', 200);
            $table->unsignedBigInteger('tax_id')->index('tax_id');
            $table->decimal('discount', 5)->nullable()->default(0);
            $table->decimal('price', 15);
            $table->decimal('quantity', 10);
            $table->unsignedBigInteger('currency_id')->index('currency_id');
            $table->decimal('disbursements', 15)->nullable()->default(0);
            $table->decimal('tax_rate', 5)->nullable()->default(0);
            $table->decimal('tax_amount', 15)->nullable()->default(0);
            $table->decimal('total', 15)->nullable()->default(0);
            $table->enum('status', ['draft', 'sent', 'paid', 'overdue'])->nullable()->default('draft');
            $table->unsignedBigInteger('user_id')->index('user_id');
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();

            $table->index(['client_id', 'status'], 'idx_client_status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('client_invoices');
    }
};
