<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('client_journals', function (Blueprint $table) {
            $table->integer('id', true);
            $table->date('date')->index('idx_date');
            $table->string('client_code', 50)->index('idx_client_code');
            $table->string('client_name', 191);
            $table->text('narration')->nullable();
            $table->decimal('dr', 15)->nullable()->default(0);
            $table->decimal('cr', 15)->nullable()->default(0);
            $table->enum('status', ['pending', 'approved', 'rejected', 'reversed'])->nullable()->default('pending');
            $table->integer('client_id')->nullable();
            $table->string('transaction_code', 50)->nullable()->unique('transaction_code');
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('client_journals');
    }
};
