<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('client_quotations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('client_id');
            $table->string('quotation_number', 200)->unique('quotation_number');
            $table->date('quotation_date')->index('idx_quotation_date');
            $table->text('terms')->nullable();
            $table->integer('validity_period')->nullable()->default(30);
            $table->text('notes')->nullable();
            $table->enum('status', ['draft', 'sent', 'accepted', 'rejected'])->nullable()->default('draft');
            $table->decimal('total_amount', 15)->nullable()->default(0);
            $table->unsignedBigInteger('user_id')->index('user_id');
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();

            $table->index(['client_id', 'status'], 'idx_client_status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('client_quotations');
    }
};
