<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('client_receipts', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('client_id');
            $table->string('receipt_number', 200)->unique('receipt_number');
            $table->date('receipt_date')->index('idx_receipt_date');
            $table->string('payment_method', 200);
            $table->enum('status', ['draft', 'processed'])->nullable()->default('draft');
            $table->decimal('total_amount', 15)->nullable()->default(0);
            $table->unsignedBigInteger('user_id')->index('user_id');
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();

            $table->index(['client_id', 'status'], 'idx_client_status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('client_receipts');
    }
};
