<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('clients', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('client_id', 10)->unique('client_id');
            $table->string('first_name', 100);
            $table->string('last_name', 100);
            $table->string('national_id', 191)->nullable()->unique('national_id');
            $table->date('date_of_birth')->nullable();
            $table->string('gender', 20)->nullable();
            $table->string('phone_primary', 20)->nullable();
            $table->string('email', 191)->nullable();
            $table->string('street_address', 191)->nullable();
            $table->string('city', 100)->nullable();
            $table->string('state_province', 100)->nullable();
            $table->string('country', 100)->nullable();
            $table->string('employer_name', 150)->nullable();
            $table->string('position_role', 100)->nullable();
            $table->string('client_type', 50)->nullable();
            $table->string('client_category', 50)->nullable();
            $table->date('date_onboarded')->nullable();
            $table->string('assigned_lawyer', 100)->nullable();
            $table->string('referred_lawyer', 100)->nullable();
            $table->text('notes')->nullable();
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('clients');
    }
};
