<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('company_info', function (Blueprint $table) {
            $table->bigIncrements('company_id');
            $table->string('company_name', 150)->nullable();
            $table->string('company_code', 10)->nullable();
            $table->text('address')->nullable();
            $table->string('contact_email', 191)->nullable();
            $table->string('contact_phone', 50)->nullable();
            $table->string('website', 100)->nullable();
            $table->string('tax_id', 120)->nullable();
            $table->text('bank_name')->nullable();
            $table->string('bank_acc_number', 50)->nullable();
            $table->unsignedBigInteger('updated_by')->nullable()->index('updated_by');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('company_info');
    }
};
