<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('court_areas', function (Blueprint $table) {
            $table->string('area_code', 20)->primary();
            $table->string('area_name', 150);
            $table->string('city', 100)->nullable();
            $table->string('country', 100)->nullable()->default('Zimbabwe');
            $table->string('specific_location', 191)->nullable();
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('court_areas');
    }
};
