<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('court_filing_statuses', function (Blueprint $table) {
            $table->bigIncrements('filing_status_id');
            $table->string('status_code', 20)->unique('status_code');
            $table->string('status_name', 100);
            $table->text('description')->nullable();
            $table->integer('display_order')->nullable()->default(0);
            $table->boolean('is_final')->nullable()->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('court_filing_statuses');
    }
};
