<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('court_filings', function (Blueprint $table) {
            $table->bigIncrements('filing_id');
            $table->unsignedBigInteger('case_id')->index('case_id');
            $table->unsignedBigInteger('filing_type_id')->nullable()->index('filing_type_id');
            $table->unsignedBigInteger('filing_status_id')->nullable()->index('filing_status_id');
            $table->string('filing_code', 50)->unique('filing_code');
            $table->string('filing_title', 191);
            $table->text('filing_description')->nullable();
            $table->string('court_area_id', 20)->nullable()->index('court_area_id');
            $table->unsignedBigInteger('judge_id')->nullable()->index('judge_id');
            $table->date('filing_date');
            $table->date('due_date')->nullable();
            $table->date('court_acknowledgment')->nullable();
            $table->string('document_path', 191)->nullable();
            $table->string('version', 50)->nullable()->default('1.0');
            $table->string('next_action', 191)->nullable();
            $table->text('internal_notes')->nullable();
            $table->text('external_notes')->nullable();
            $table->unsignedBigInteger('created_by')->nullable()->index('created_by');
            $table->unsignedBigInteger('updated_by')->nullable()->index('updated_by');
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('court_filings');
    }
};
