<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('currency_rates', function (Blueprint $table) {
            $table->bigIncrements('rate_id');
            $table->unsignedBigInteger('base_currency_id');
            $table->unsignedBigInteger('target_currency_id')->index('target_currency_id');
            $table->date('rate_date')->nullable();
            $table->decimal('exchange_rate', 18, 6);
            $table->string('source', 100)->nullable();
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();

            $table->unique(['base_currency_id', 'target_currency_id', 'rate_date'], 'unique_currency_rate');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('currency_rates');
    }
};
