<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('diary_entries', function (Blueprint $table) {
            $table->bigIncrements('diary_id');
            $table->unsignedBigInteger('assignment_id')->nullable()->index('assignment_id');
            $table->dateTime('date_time');
            $table->string('task_title', 191);
            $table->string('client_case', 191)->nullable();
            $table->enum('task_type', ['meeting', 'court-filing', 'draft-review', 'call', 'follow-up', 'internal-task', 'other']);
            $table->enum('priority', ['low', 'medium', 'high']);
            $table->enum('status', ['pending', 'in-progress', 'completed', 'deferred'])->nullable()->default('pending');
            $table->enum('location', ['office', 'courtroom', 'online-meeting', 'phone-call', 'other'])->nullable();
            $table->string('duration', 50)->nullable();
            $table->text('notes')->nullable();
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('diary_entries');
    }
};
