<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('filing_responsible_lawyers', function (Blueprint $table) {
            $table->bigIncrements('filing_lawyer_id');
            $table->unsignedBigInteger('filing_id');
            $table->string('lawyer_id', 20)->index('lawyer_id');
            $table->string('role_in_filing', 100);
            $table->text('notes')->nullable();
            $table->date('assigned_date')->nullable();

            $table->unique(['filing_id', 'lawyer_id'], 'unique_filing_lawyer');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('filing_responsible_lawyers');
    }
};
