<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('general_journals', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('account', 100);
            $table->date('date');
            $table->text('narration')->nullable();
            $table->string('transaction_code', 50)->unique('transaction_code');
            $table->string('currency', 3)->nullable()->default('USD');
            $table->decimal('amount', 15);
            $table->enum('status', ['pending', 'approved', 'rejected', 'reversed'])->nullable()->default('pending');
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('general_journals');
    }
};
