<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('general_ledger_accounts', function (Blueprint $table) {
            $table->bigIncrements('account_id');
            $table->unsignedBigInteger('parent_id')->nullable()->index('general_ledger_accounts_parent_id_foreign');
            $table->string('code', 191)->unique('code');
            $table->string('name', 150);
            $table->string('financial_category', 100)->nullable();
            $table->unsignedBigInteger('account_type_id')->index('account_type_id');
            $table->string('department_code', 50)->nullable()->index('department_code');
            $table->boolean('has_subaccounts')->nullable()->default(false);
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('general_ledger_accounts');
    }
};
