<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('group_calls', function (Blueprint $table) {
            $table->bigIncrements('call_id');
            $table->unsignedBigInteger('chat_id')->index('chat_id');
            $table->unsignedBigInteger('initiated_by')->index('initiated_by');
            $table->enum('call_type', ['audio', 'video']);
            $table->enum('status', ['ongoing', 'ended', 'missed'])->nullable()->default('ongoing');
            $table->timestamp('started_at')->nullable()->useCurrent();
            $table->timestamp('ended_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('group_calls');
    }
};
