<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('journal_transactions', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('transaction_code', 50)->index('idx_transaction_code');
            $table->enum('journal_type', ['general', 'client', 'supplier']);
            $table->integer('journal_id');
            $table->date('date');
            $table->decimal('amount', 15);
            $table->enum('status', ['pending', 'approved', 'rejected', 'reversed'])->nullable()->default('pending');
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->nullable()->useCurrent();

            $table->index(['journal_type', 'journal_id'], 'idx_journal_type');
            $table->unique(['transaction_code'], 'transaction_code');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('journal_transactions');
    }
};
