<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('judges', function (Blueprint $table) {
            $table->bigIncrements('judge_id');
            $table->string('judge_code', 20)->unique('judge_code');
            $table->string('full_name', 150);
            $table->string('court_area_code', 20)->nullable()->index('court_area_code');
            $table->string('court_type_name', 100)->nullable()->index('court_type_name');
            $table->string('contact', 50)->nullable();
            $table->string('email', 191)->nullable();
            $table->string('status', 20)->nullable()->default('Active');
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
            $table->text('notes')->nullable();
            $table->boolean('is_active')->nullable()->default(true);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('judges');
    }
};
