<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('lawyer_roles', function (Blueprint $table) {
            $table->increments('lawyer_role_id');
            $table->string('code', 50)->unique('code');
            $table->string('name', 100);
            $table->text('description')->nullable();
            $table->enum('side', ['plaintiff', 'defendant', 'prosecution', 'defense', 'neutral'])->default('neutral');
            $table->boolean('is_primary')->default(false);
            $table->boolean('requires_bar_status')->default(true);
            $table->enum('jurisdiction_scope', ['US', 'UK', 'GLOBAL'])->default('GLOBAL');
            $table->boolean('is_active')->default(true);
            $table->unsignedInteger('sort_order')->nullable();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('lawyer_roles');
    }
};
