<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('lawyers', function (Blueprint $table) {
            $table->string('lawyer_id', 20)->primary();
            $table->string('first_name', 100);
            $table->string('last_name', 100);
            $table->string('email', 191)->unique('email');
            $table->string('phone_primary', 20);
            $table->string('phone_secondary', 20)->nullable();
            $table->string('lawyer_group', 100)->nullable();
            $table->string('certificate_number', 191)->nullable();
            $table->date('date_of_admission')->nullable();
            $table->string('status', 20)->nullable()->default('Active');
            $table->string('lawyer_type', 50)->nullable();
            $table->string('lawyer_tier', 50)->nullable();
            $table->text('notes')->nullable();
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
            $table->integer('tier_id')->nullable()->index('fk_lawyer_tier');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('lawyers');
    }
};
