<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->bigIncrements('notification_id');
            $table->unsignedBigInteger('user_id')->index('user_id');
            $table->enum('type', ['message', 'call', 'group', 'request', 'system'])->nullable()->default('message');
            $table->string('title', 191)->nullable();
            $table->text('content')->nullable();
            $table->unsignedBigInteger('related_id')->nullable();
            $table->enum('related_type', ['chat', 'call', 'group', 'system'])->nullable();
            $table->boolean('is_read')->nullable()->default(false);
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('read_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notifications');
    }
};
