<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('permissions', function (Blueprint $table) {
            $table->bigIncrements('permission_id');
            $table->unsignedBigInteger('feature_id')->index('feature_id');
            $table->boolean('can_view')->nullable()->default(false);
            $table->boolean('can_add')->nullable()->default(false);
            $table->boolean('can_edit')->nullable()->default(false);
            $table->boolean('can_delete')->nullable()->default(false);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('permissions');
    }
};
