<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('prompt_conversations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('user_id')->index('idx_conversations_user_id');
            $table->string('title', 191)->nullable();
            $table->string('model', 50)->nullable();
            $table->integer('total_messages')->nullable()->default(0);
            $table->integer('total_tokens')->nullable()->default(0);
            $table->string('status', 20)->nullable()->default('active')->index('idx_conversations_status');
            $table->timestamp('created_at')->nullable()->useCurrent()->index('idx_conversations_created_at');
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
            $table->timestamp('last_message_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('prompt_conversations');
    }
};
