<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('supplier_ageing_analysis', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('age_code', 50);
            $table->string('description');
            $table->enum('ageing_group', ['monthly', 'daily', 'custom']);
            $table->enum('interval_type', ['statement_date', 'invoice_date']);
            $table->string('interval_value', 50);
            $table->text('custom_age_groups')->nullable();
            $table->text('custom_intervals')->nullable();
            $table->string('actions')->nullable();
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('supplier_ageing_analysis');
    }
};
