<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('supplier_areas', function (Blueprint $table) {
            $table->integer('area_id', true);
            $table->string('area_code', 50)->unique('area_code');
            $table->string('area_name', 191);
            $table->string('city', 100)->nullable();
            $table->string('country', 100)->nullable();
            $table->text('specific_location')->nullable();
            $table->timestamp('created_at')->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('supplier_areas');
    }
};
