<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('supplier_invoices', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('supplier_id')->index('idx_supplier_invoices_supplier_id');
            $table->string('invoice_number')->index('idx_supplier_invoices_invoice_number');
            $table->date('invoice_date')->index('idx_supplier_invoices_invoice_date');
            $table->string('reference_number');
            $table->text('description');
            $table->string('contact_person');
            $table->text('narration')->nullable();
            $table->string('reference_det');
            $table->string('gl_account')->index('idx_supplier_invoices_gl_account');
            $table->unsignedBigInteger('tax_id');
            $table->decimal('discount', 5)->default(0);
            $table->decimal('price', 15);
            $table->decimal('quantity', 10)->default(1);
            $table->unsignedBigInteger('currency_id');
            $table->decimal('operation_cost', 15)->default(0);
            $table->timestamp('created_at')->nullable()->useCurrent()->index('idx_supplier_invoices_created_at');
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();

            $table->unique(['invoice_number'], 'invoice_number');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('supplier_invoices');
    }
};
