<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('supplier_journals', function (Blueprint $table) {
            $table->integer('id', true);
            $table->date('date')->index('idx_date');
            $table->string('supplier_code', 50)->index('idx_supplier_code');
            $table->string('supplier_name', 191);
            $table->text('narration')->nullable();
            $table->decimal('dr', 15)->nullable()->default(0);
            $table->decimal('cr', 15)->nullable()->default(0);
            $table->enum('status', ['pending', 'approved', 'rejected', 'reversed'])->nullable()->default('pending');
            $table->integer('supplier_id')->nullable();
            $table->string('transaction_code', 50)->nullable()->unique('transaction_code');
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('supplier_journals');
    }
};
