<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('suppliers', function (Blueprint $table) {
            $table->integer('supplier_id', true);
            $table->string('supplier_code', 50)->unique('supplier_code');
            $table->string('supplier_name', 191);
            $table->string('full_name', 191)->nullable();
            $table->string('contact_person', 191)->nullable();
            $table->string('contact_1', 50)->nullable();
            $table->string('contact_2', 50)->nullable();
            $table->string('email', 191)->nullable();
            $table->text('address')->nullable();
            $table->integer('category_id')->nullable()->index('fk_supplier_category');
            $table->integer('age_analysis_id')->nullable()->index('fk_supplier_ageing');
            $table->integer('area_id')->nullable()->index('fk_supplier_area');
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('suppliers');
    }
};
