<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('system_settings_history', function (Blueprint $table) {
            $table->bigIncrements('history_id');
            $table->unsignedBigInteger('setting_id')->nullable()->index('setting_id');
            $table->string('old_value', 191)->nullable();
            $table->string('new_value', 191)->nullable();
            $table->unsignedBigInteger('changed_by')->nullable()->index('changed_by');
            $table->timestamp('changed_at')->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('system_settings_history');
    }
};
