<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tariffs', function (Blueprint $table) {
            $table->integer('tariff_id', true);
            $table->integer('lawyer_id')->index('fk_tariff_lawyer');
            $table->integer('tier_id')->index('fk_tariff_tier');
            $table->integer('group_id')->index('fk_tariff_group');
            $table->integer('type_id')->index('fk_tariff_type');
            $table->string('service_name', 150);
            $table->enum('billing_method', ['HOURLY', 'FIXED_FEE', 'PER_APPEARANCE', 'PER_STAGE', 'RETAINER_PLUS', 'CONTINGENCY', 'SUBSCRIPTION']);
            $table->enum('rate_type', ['PER_HOUR', 'PER_CASE', 'PER_DOCUMENT', 'PER_APPEARANCE', 'PER_CONSULTATION', 'PER_MONTH', 'PERCENTAGE']);
            $table->decimal('rate_amount', 12);
            $table->char('currency', 3)->nullable()->default('USD');
            $table->integer('billing_increment')->nullable()->default(60)->comment('Minutes (15, 30, 60)');
            $table->decimal('minimum_fee', 12)->nullable();
            $table->decimal('maximum_fee', 12)->nullable();
            $table->boolean('retainer_required')->nullable()->default(false);
            $table->decimal('retainer_amount', 12)->nullable();
            $table->enum('court_level', ['MAGISTRATES', 'HIGH_COURT', 'SUPREME_COURT', 'CONSTITUTIONAL_COURT'])->nullable();
            $table->enum('complexity_level', ['LOW', 'MEDIUM', 'HIGH'])->nullable()->default('MEDIUM');
            $table->boolean('tax_inclusive')->nullable()->default(false);
            $table->decimal('vat_rate', 5)->nullable()->default(0);
            $table->date('effective_from');
            $table->date('effective_to')->nullable();
            $table->text('description')->nullable();
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable()->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tariffs');
    }
};
